#!/usr/bin/env python
"""
Tor z samochodzikami połączony z kartą PiFace
"""
import time                     # Na potrzeby dodawania opóźnień
import piface.pfio as pfio      # Biblioteka piface
import random
import os, pygame, sys

pfio.init()                     # Inicjowanie obiektu pfio
pygame.init()                   # Inicjowanie interfejsu graficznego
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Tor z samochodzikami")
screen = pygame.display.set_mode([980,610],0,32)
background = pygame.Surface((980,610))
piSurface = pygame.Surface((555,540))

# Definiowanie kolorów interfejsu użytkownika
cBackground =(255,255,255)
cLEDon = (255,0,0)
cLEDoff = (128,128,128)
cOutline = (255,128,0)
cText = (0,0,0)
cTextBack = (220,220,220)
altcText = (255,255,255)
altcTextBack = (180,180,180)
cStepBlock = (0,255,255)
# Obsługa sytuacji, w której brak jest grafiki jadącego kawałka ciasta
try:
   piPicture = pygame.image.load("racingLogo.png").convert_alpha()
   piSurface.blit(piPicture,[0,0])
except:
   piSurface.fill((220,220,220)) # Generowanie szarego obszaru
# Konfigurowanie pytań
qfile = open("questions.txt","r")
questions = list()
numberOfQuestions = 0
for line in qfile.readlines():
        questions.append(line)
        numberOfQuestions +=1
qfile.close()
random.shuffle(questions)
placeX = [490,490,355,625,490, 150, 800]
placeY = [ 20, 110, 305, 305, 510, 80 ,80]
aPos = [-1,-1,-1,-1]
single = [0, 1, 2, 0, 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0] 

background.fill(cBackground) # Określanie koloru tła
font = pygame.font.Font(None, 28)
seq = [ 1 << (temp & 0x7) for temp in range (0,32)] # Początkowa sekwencja
timeInc = 0.3
stepInt = True # Pobieranie z Raspberry Pi sygnału o przejściu do następnego kroku 
step = 0 # Początek sekwencji
nextTime = time.time()
answer = "answer"
answerPos = -1


def main():
        ask =0
        while True :
            while pfio.read_input() != 0:
               checkForEvent()  # Oczekiwanie na zwolnienie przełącznika
            setupScreen(ask)
            checkInput()
            ask += 1
            if ask >= numberOfQuestions :
               ask = 0
               random.shuffle(questions)
            
def checkInput():
   buttonsInput = 0
   while buttonsInput == 0:
      buttonsInput = 1
      checkForEvent()
   if buttonsInput >= 1 :
      first = " Gracz 2 "
      second = " Gracz 1 "
      buttonsInput = buttonsInput >> 4
      bits = 0x26
   else:
      first = " Gracz 1 "
      second = " Gracz 2 "
      bits = 0x19
   #print hex(buttonsInput), single[buttonsInput] , answerPos
   if single[buttonsInput] == answerPos:
      drawWords("Dobrze."+first+"wygrywa", 5, False)
      drawWords(first+"otrzymuje 3 sekundy", 6, False)
      pfio.write_output(bits)
   else:
      drawWords("Niedobrze."+first+"przegrywa", 5, False)
      drawWords(second+"otrzymuje 3 sekundy", 6, False)
      pfio.write_output(bits ^ 0x3f)
   correct()   
   pfio.write_output(0)
   correct() # Miganie lampkami
      
   
def scramble():
    global aPos
    aPos = [-1,-1,-1,-1]
    for p in range(0,4):
       match = True
       while match:
         match = False
         candadate = random.randint(1,4)
         for i in range(0,4):
            if aPos[i] == candadate:
               match = True
       aPos[p] = candadate
    #print aPos
     
def setupScreen(question) : # Inicjowanie zawartości ekranu
    global answer, answerPos
    screen.blit(background,[0,0]) # Określanie koloru tła
    screen.blit(piSurface,[210,50])
    pygame.display.update()
    time.sleep(2.0) # Opóźnienie dające graczom czas na przygotowanie się
    q = questions[question].split(",")
    scramble()
    drawWords(q[0].decode('UTF-8'),0, False)
    drawWords(q[1].decode('UTF-8'),aPos[0], False)
    drawWords(q[2].decode('UTF-8'),aPos[1], False)
    drawWords(q[3].decode('UTF-8'),aPos[2], False)
    drawWords(q[4].decode('UTF-8'),aPos[3], False)
    pygame.display.update()
    answer = q[1]
    answerPos = aPos[0]

def drawWords(words,pos,inv) :
        if inv :
           text = font.render(words, True, altcText, altcTextBack )
        else :
           text = font.render(words, True, cText, cTextBack )
        textRect = text.get_rect()
        if pos == 2 :
           textRect.right = placeX[2] 
        elif pos == 3:
           textRect.left = placeX[3] 
        else:
           textRect.centerx = placeX[pos]
        textRect.top = placeY[pos]   
        pygame.draw.rect(screen,cTextBack, textRect, 0)
        screen.blit(text, textRect)
        pygame.draw.rect(screen,cOutline, textRect, 2)
        
def correct() :
    nextTime = 0
    for flash in range(0,10) :
      while time.time() < nextTime :
         pass
      if flash & 1:
         drawWords(answer,answerPos, False)
      else :
         drawWords(answer,answerPos, True)
      pygame.display.update() 
      nextTime = time.time() + 0.3
       
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu – proszę czekać")
    pfio.deinit() # Zamykanie obiektu pfio
    pygame.quit() # Zamykanie obiektu pygame
    sys.exit()
    
def checkForEvent(): # Wykrywanie zdarzeń związanych z zamykaniem programu i myszą
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    elif event.type == pygame.KEYDOWN :
        if event.key == pygame.W :
            pass
        if event.key == pygame.R :
            pass
    elif event.type == pygame.KEYDOWN and event.key == pygame.K_ESCAPE :
            terminate()
            
            
if __name__ == '__main__':
    main()   
